/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build.xml;

import DE.siemens.ad.logo.model.AnalogMathsParameter;
import DE.siemens.ad.logo.model.AstronomicalClockParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.ClockHours;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HoursCounterParameter;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.MathDetectionParameter;
import DE.siemens.ad.logo.model.Mode;
import DE.siemens.ad.logo.model.Months;
import DE.siemens.ad.logo.model.PIDParameter;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemIdentifierTableLogo7;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.model.TimeBase;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.UnlimitedHours;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.ClockBlock;
import DE.siemens.ad.logo.model.visitor.build.Visitor;
import DE.siemens.ad.logo.model.visitor.build.xml.CompileWDToXml;
import DE.siemens.ad.logo.util.ElementCodeBlock;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.TimeValueProperties;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.udf.UDFBlock;
import org.dom4j.Element;

public abstract class CompileWDToXmlLogo
extends Visitor
implements CompileWDToXml {
    protected Hardware fHW;

    public Element compile(UDFBlock udfBlock, Element parent) {
        throw new UnsupportedOperationException();
    }

    public Element compile(WiringDiagram wd, Element parent) {
        throw new UnsupportedOperationException();
    }

    public Element visit(Block block, Element parenentNode) {
        Element blockNode = parenentNode.addElement("Block").addAttribute("opcode", String.valueOf(block.getOpcode(block.getHardware(), 0))).addAttribute("blockNumber", String.valueOf(block.getNumber())).addAttribute("name", block.getUserDefinedName());
        this.saveInconnectorsInfo(block, blockNode);
        return blockNode;
    }

    public Element visit(ClockBlock block, Element parenentNode) {
        Element blockNode = parenentNode.addElement("Block").addAttribute("opcode", String.valueOf(block.getOpcode(block.getHardware(), 0))).addAttribute("blockNumber", String.valueOf(block.getNumber())).addAttribute("name", block.getUserDefinedName());
        this.acceptVisit(block.getParameter(), blockNode).addAttribute("index", "0");
        return blockNode;
    }

    public Element visit(BlockParameter parameter, Element parenentNode) {
        return this.storeParameterBasicInfo(parameter, parenentNode);
    }

    public Element visit(AnalogMathsParameter parameter, Element parentElement) {
        Element parameterNode = this.storeParameterBasicInfo(parameter, parentElement);
        parameterNode.addElement("Mode").setText(String.valueOf(parameter.getEnOutputOptionID()));
        Element operatorsNode = parameterNode.addElement("Operators");
        for (int i = 0; i < parameter.getOpNum(); ++i) {
            operatorsNode.addElement("Operator").addText(String.valueOf(parameter.getOperator(i))).addAttribute("priority", String.valueOf(parameter.getOpPRI(i)));
        }
        return parameterNode;
    }

    public Element visit(PIDParameter parameter, Element parenentNode) {
        Element parameterNode = this.storeParameterBasicInfo(parameter, parenentNode);
        parameterNode.addElement("ParameterSet").setText(String.valueOf(parameter.getParameterset()));
        return parameterNode;
    }

    public Element visit(AstronomicalClockParameter parameter, Element parentElement) {
        Element parameterNode = this.storeParameterBasicInfo(parameter, parentElement);
        String city = parameter.getCity();
        if (city == null) {
            city = "";
        }
        parameterNode.addElement("City").addText(city);
        return parameterNode;
    }

    public Element visit(MathDetectionParameter parameter, Element parenentNode) {
        Element parameterNode = parenentNode.addElement("Parameter");
        if (parameter instanceof ProtectionParameter) {
            parameterNode.addElement("Protection").addText(String.valueOf(parameter.getProtection()));
        }
        ParameterItemList list = parameter.getParameterItems().getParameterItemListOfType(0).instance(parameter);
        for (int i = 0; i < list.size(); ++i) {
            Element paraItem;
            ParameterItem parameterItem = (ParameterItem)list.get(i);
            if (parameterItem.getIdentifier().equals("BN")) {
                paraItem = parameterNode.addElement(parameterItem.getIdentifier());
                paraItem.setText(String.valueOf(parameter.getReferencedBlockNumber()));
                continue;
            }
            if (parameterItem.getIdentifier().equals("DE")) {
                paraItem = parameterNode.addElement(parameterItem.getIdentifier());
                if (parameter.isDetectZeroDivision() && parameter.isDetectOverflow()) {
                    paraItem.setText("0");
                    continue;
                }
                if (parameter.isDetectZeroDivision()) {
                    paraItem.setText("1");
                    continue;
                }
                paraItem.setText("2");
                continue;
            }
            this.storeParameterItem(parameterItem, parameterNode);
        }
        return parameterNode;
    }

    public Element visit(InBlockConnector connector, Element parenentNode) {
        Element connectorNode = parenentNode.addElement("InConnector").addAttribute("negate", String.valueOf(connector.isNegated()));
        Block prev = connector.getLinkedBlock();
        if (prev != null) {
            connectorNode.addAttribute("opcode", String.valueOf(prev.getOpcode(prev.getHardware(), 0))).addAttribute("blockNumber", String.valueOf(prev.getNumber()));
        } else {
            connectorNode.addAttribute("opcode", "255");
        }
        return connectorNode;
    }

    public Element visit(ParameterInBlockConnector connector, Element parenentNode) {
        return this.acceptVisit(connector.getLinkedParameter(), parenentNode);
    }

    protected Element storeParameterItem(ParameterItem parameterItem, Element parameterNode) {
        ParameterItemIdentifierTableLogo7 identifierTable = (ParameterItemIdentifierTableLogo7)this.fHW.getProperty("parameterItemIdentifierTable");
        Element paraItem = parameterNode.addElement(identifierTable.getXmlIdentifier(parameterItem.getParameter(), parameterItem.getIdentifier()));
        Object paraValue = parameterItem.getValue();
        if (paraValue instanceof TimeValueProperties) {
            this.storeTimerOrReference((TimeValueProperties)paraValue, paraItem);
        } else if (paraValue instanceof IntegerOrBlockReference) {
            this.storeIntegerOrBlockReference((IntegerOrBlockReference)paraValue, paraItem);
        } else if (paraValue instanceof IntValueProperties) {
            this.storeIntValueProperties((IntValueProperties)paraValue, paraItem);
        } else if (paraValue instanceof Mode) {
            paraItem.addText(String.valueOf(((Mode)paraValue).getLogoMode()));
        } else if (paraValue instanceof TimeBase) {
            this.storeTimeBase((TimeBase)paraValue, paraItem);
        } else if (paraValue instanceof ClockHours) {
            this.storeClockHours((ClockHours)paraValue, paraItem);
        } else if (paraValue instanceof Months) {
            paraItem.addAttribute("monthly", String.valueOf(((Months)paraValue).isEveryMonth()));
            paraItem.addText(String.valueOf(((Months)paraValue).getHighValue() << 16 | ((Months)paraValue).getLowValue()));
        } else if (paraValue != null) {
            paraItem.addText(paraValue.toString());
        }
        return paraItem;
    }

    protected void storeTimerOrReference(TimeValueProperties property, Element parenentNode) {
        int value;
        TimeUnit tu = property.getCurrentValue();
        parenentNode.addAttribute("isReference", String.valueOf(property.isReference())).addAttribute("lowMin", String.valueOf(tu.getLowMin())).addAttribute("lowMax", String.valueOf(tu.getLowMax())).addAttribute("highMin", String.valueOf(tu.getHighMin())).addAttribute("highMax", String.valueOf(tu.getHighMax()));
        int[] time = tu.getLogoTime();
        if (property.isReference()) {
            Block referenceBlock = property.getReference().getParameter().getBlock();
            value = Util.makeSignedDoubleWord(0, referenceBlock.getOpcode(), time[0], time[1]);
        } else {
            value = property.getCurrentValue() instanceof UnlimitedHours ? Util.makeSignedDoubleWord(time[0], time[1], time[2], time[3]) : Util.makeWord(time[1], time[0]);
        }
        parenentNode.addText(String.valueOf(value));
    }

    protected void storeIntValueProperties(IntValueProperties property, Element parenentNode) {
        parenentNode.addAttribute("max", String.valueOf(property.getMax())).addAttribute("min", String.valueOf(property.getMin())).addAttribute("incre", String.valueOf(property.getInc())).addText(String.valueOf(property.getCurrentValue()));
    }

    protected void storeIntegerOrBlockReference(IntegerOrBlockReference property, Element parenentNode) {
        int value;
        parenentNode.addAttribute("isReference", String.valueOf(property.isReference())).addAttribute("max", String.valueOf(property.getIntValueProperties().getMax())).addAttribute("min", String.valueOf(property.getIntValueProperties().getMin())).addAttribute("incre", String.valueOf(property.getIntValueProperties().getInc()));
        if (property.isReference()) {
            Block referenceBlock = property.getReferenceToBlock();
            value = Util.makeSignedDoubleWord(0, 0, referenceBlock.getNumber(), referenceBlock.getOpcode(referenceBlock.getHardware(), 0));
        } else {
            value = property.getValue();
        }
        parenentNode.addText(String.valueOf(value));
    }

    protected void storeTimeBase(TimeBase timebase, Element parentNode) {
        parentNode.addAttribute("key", String.valueOf(timebase.getTimeBaseKey())).addText(String.valueOf(timebase.getTime()));
    }

    protected void storeClockHours(ClockHours clockHours, Element parentNode) {
        parentNode.addAttribute("inactive", String.valueOf(clockHours.isInactive())).addText(String.valueOf(clockHours.toString()));
    }

    protected Element storeParameterBasicInfo(BlockParameter parameter, Element parenentNode) {
        Element parameterNode = parenentNode.addElement("Parameter");
        if (parameter instanceof ProtectionParameter) {
            parameterNode.addElement("Protection").addText(String.valueOf(((ProtectionParameter)parameter).getProtection()));
        }
        ParameterItemList list = parameter.getParameterItems().getParameterItemListOfType(0).instance(parameter);
        for (int i = 0; i < list.size(); ++i) {
            ParameterItem parameterItem = (ParameterItem)list.get(i);
            if (parameter instanceof HoursCounterParameter && parameterItem.getIdentifier().equals("MI")) continue;
            this.storeParameterItem(parameterItem, parameterNode);
        }
        return parameterNode;
    }

    public Element acceptVisit(Object parameter1, Element parameter2) {
        ElementCodeBlock c = new ElementCodeBlock(this, "visit");
        c.addParameter(parameter1);
        c.addParameter(parameter2);
        Element returnValue = null;
        try {
            returnValue = (Element)c.execMethod();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    protected void saveInconnectorsInfo(Block block, Element blockNode) {
        InBlockConnector[] inConnectors = block.getInConnectors();
        if (inConnectors != null) {
            for (int i = 0; i < inConnectors.length; ++i) {
                this.acceptVisit(inConnectors[i], blockNode).addAttribute("index", String.valueOf(i));
            }
        }
    }
}

